# Plan général de développement après V1 – Synthèse des objectifs

## 0. Vision d’ensemble

- Logiciel = gestionnaire de projets universels, extrêmement modulable et flexible, basé sur un noyau V4 strict (snapshot, tags, packs MCC, bus de commandes).
- V1 actuelle = socle fonctionnel minimal + moteur logique + système de packs déjà en place.
- Objectif global = atteindre une version « finie » (par rapport à tes attentes) où :
  - les fonctionnalités avancées (gestion, relations, interactions, logique, teams, community) cohabitent sans contradictions,
  - le système reste propre, cohérent, découplé, sans solutions ad hoc accumulées.

## 1. Capacités transverses à préparer avant les packs

### 1.1 Identifiants universels

- Chaque node (container ou leaf) DOIT avoir un identifiant unique et universel à l’échelle du logiciel, pas seulement du board.
- Chaque board DOIT aussi avoir un identifiant universel (pas deux boards « identiques » à l’échelle du logiciel).
- On veut un adressage complet, permettant de référencer un item de manière fiable, notamment pour :
  - des actions cross-board,
  - des relations cross-board,
  - des interactions qui ciblent des items répartis dans plusieurs endroits.
- Syntaxe d’adresse encore à définir (exemples possibles : `utilisateur/board/item`, `{boardId,nodeId}`, etc.), mais l’exigence est : adressage strictement fiable et universel.

### 1.2 Système de sélection universelle d’items

- Besoin d’un mécanisme standardisé, réutilisable par de nombreux composants, pour « pointer » un item (container ou leaf) :
  - l’UI entre dans un état « pending »,
  - l’utilisateur choisit un item quelque part sur un board,
  - le système capture son identifiant unique pour le transmettre à la fonction qui en a besoin.
- Exemples d’UI possibles :
  - menu contexte sur clic droit d’un item (relations, déplacer, etc.),
  - menu « trois petits points » à côté des actions (poubelle, renommage, etc.).
- Idée générale : même moteur de sélection, plusieurs interfaces possibles :
  - clic dans le board,
  - choix dans un side panel (liste filtrée),
  - autre interface (recherche, etc.).
- Ce système sera utilisé par :
  - le déplacement d’items entre containers (y compris cross-workspace/board),
  - le pack Relations (choisir from/to),
  - le pack Interaction (choisir les cibles d’actions),
  - d’autres assistants ultérieurs.

### 1.3 Déplacement d’items via adressage

- Aujourd’hui : drag & drop possible entre containers dans un même workspace, mais pas entre workspaces.
- Objectif : permettre de déplacer un item vers un autre container (éventuellement dans un autre workspace/board) en s’appuyant sur :
  - le système d’adressage universel,
  - le système de sélection universelle (l’utilisateur sélectionne le container cible via ce mécanisme).

## 2. Pack Gestion

### 2.1 Nouveaux tags d’état système

- Introduction de nouveaux tags d’état système (même famille que « à faire / en cours / terminé »), par exemple :
  - en retard,
  - bloqué,
  - échoué.
- Ces tags sont destinés à enrichir la gestion opérationnelle des items.

### 2.2 Dates, échéances, temporalité

- Ajout d’un système de dates / échéances pour les items :
  - un item peut avoir plusieurs échéances ;
  - chaque échéance a :
    - un label,
    - une catégorie (ex. `start`, `due`, `review`, etc.),
    - une date effective ;
  - pour un couple (item, catégorie), on limite à une seule échéance (pas deux `due` différentes sur le même item) ;
  - les échéances sont éditables via un side panel dédié dans la fenêtre d’édition d’un item.
- Des règles logiques seront associées à ces catégories, par exemple :
  - « si date actuelle > date d’une échéance de catégorie `deadline` → appliquer automatiquement le tag `en retard` à tous les objets associés à cette échéance ».
- L’objectif est de lier temps, états et tags de façon automatisée et intelligible.

### 2.3 Tag de progression / barre de progression

- Introduction d’un tag système de progression (nom exact à définir, ex. `progression`) pour remplacer avec finesse l’usage des tags d’état « en cours » / « terminé ».
- Chaque item dispose d’un champ de progression numérique compris entre 0 et 10 000.
- Comportement prévu :
  - dans la fenêtre d’édition de l’item : ajout d’un input numérique (0 → 10 000) ;
  - sur les vignettes (containers et leafs) dans le board :
    - une barre de progression apparaît en haut de la vignette (au-dessus du titre),
    - la barre reflète exactement le niveau de résolution (0 → 0 %, 10 000 → 100 %).
- Pour les leafs :
  - la progression est toujours saisie manuellement par l’utilisateur.
- Pour les containers :
  - la progression peut être saisie manuellement (valeur indépendante des enfants),
  - ou, si l’utilisateur l’active, calculée automatiquement à partir des enfants (moyenne simple ou pondérée, à préciser avec le pack Relations).
- Effet sur la barre verticale d’état (couleur vert/rouge/orange/jaune/bleu) :
  - sa largeur devient proportionnelle à la valeur de progression, avec des paliers (ex. 0 → invisible, >10 → plus large, jusqu’à une largeur max pour 10 000).
  - les règles exactes de couplage avec les tags d’état (ex. forcer progression = 10 000 quand état = « terminé », ou seulement le suggérer) restent à trancher au niveau du pack Gestion.

## 3. Pack Relations

### 3.1 Concept de base

- Une relation est un fait de la forme :  
  `Relation { id, type, fromNodeId, toNodeId, meta? }`.
- `type` est une chaîne stable, définie par le noyau ou par un pack, exemples envisagés :
  - `rel/hierarchy` : hiérarchie métier (A est composé de B),
  - `rel/dependency` : A dépend de B (A ne peut pas être « terminé » tant que B ne l’est pas),
  - `rel/blocker` : A est bloqué par B,
  - `rel/uses` : A consomme une ressource B,
  - `rel/produces` : A produit B,
  - `rel/assigned_to` : A est assigné à l’utilisateur U (U modélisé comme node ou autre entité),
  - `rel/member_of` : A appartient à un groupe G (Teams),
  - `rel/published_in` : A est exposé dans un hub / contexte public (Community).
- Relations possibles intra-board et cross-board (un item d’un board A peut dépendre d’un item d’un board B).

### 3.2 Side panel Relations

- Un side panel dédié Relations dans la fenêtre d’édition d’un item :
  - visualiser les relations existantes (entrantes, sortantes),
  - définir de nouvelles relations,
  - modifier/supprimer des relations.
- Ce panneau doit être ergonomique et réutilisable, notamment pour :
  - les dépendances de tâches,
  - les relations de composition métier,
  - les liens avec des ressources (uses/produces),
  - les liens sociaux (Teams/Community).

### 3.3 Rendre fonctionnelle une hiérarchie visuelle existante

- Problématique forte : permettre à l’utilisateur de transformer une hiérarchie visuelle (items empilés dans un container) en hiérarchie fonctionnelle (relations explicites), par exemple :
  - un container déjà rempli d’items,
  - l’utilisateur veut que :
    - les enfants deviennent hiérarchiquement liés au container,
    - l’ordre des items dans la liste devienne une chaîne de dépendances (chaque item dépend du précédent).
- Besoin d’un mécanisme du type :
  - dans le side panel Relations d’un item container :
    - option « rendre cette liste fonctionnelle » (génération automatique des relations hiérarchie/dépendance selon l’ordre).

### 3.4 Deux stratégies envisagées pour la logique « intelligente »

- Stratégie A (tags structurants) :
  - introduire un tag dédié appliqué à un container qui, par nature, modifie le comportement des relations qui lui sont appliquées ;
  - ce tag déclenche un mode spécial où relations, hiérarchie, etc., se comportent différemment.
  - Risque : logique fondamentale qui modifie dynamiquement le comportement des tags selon que l’item est un container ou un leaf.
- Stratégie B (assistants intelligents mais tags standard) :
  - conserver un comportement standard et universel pour les tags, quel que soit le type de node ;
  - introduire dans les assistants UI (side panels) des options spécifiques lorsque l’item est un container, par exemple :
    - boutons pour générer automatiquement certaines relations selon la position/l’ordre des enfants.
- Ce choix est crucial pour la suite, car il conditionne :
  - la propreté du modèle,
  - la lisibilité des comportements,
  - l’extension future par les packs.

## 4. Pack Interaction

### 4.1 Tag système de type « action »

- Introduction d’un tag système de type « action » appliqué à un item.
- Lorsqu’un item taggué « action » est terminé, il peut déclencher des événements sur le board, par exemple :
  - création d’items (selon des filtres : nom, catégorie, état, échéance, etc.),
  - suppression d’items (selon des filtres),
  - modification de propriétés d’items (échéance, progression, quantités, catégorie),
  - application / modification de relations.

### 4.2 Interface « Avant / Après »

- Interface scindée en deux parties :
  - Avant : conditions nécessaires (pré-requis),
  - Après : ce qui est produit / modifié.
- Concept : beaucoup d’actions sont en réalité :
  - Avant : un ensemble de conditions,
  - Après : suppression / création / modification d’un ensemble de propriétés (ex. changer de catégorie = retirer A et ajouter B).
- Chaque côté de l’interface propose :
  - un système de sélection universel pour choisir le type d’interaction ciblée : nom, catégorie, état, échéance, etc.

### 4.3 Ciblage générique vs précis et fallback intelligent

- Objectif : permettre à l’utilisateur de choisir son niveau de précision :
  - générique :
    - cibler un container sans spécifier exactement quel item sera utilisé (le système choisit un item de ce container selon des critères),
  - précis :
    - cibler explicitement un ou plusieurs items via le système de sélection universel, même répartis dans plusieurs containers.
- Comportement attendu :
  - si l’utilisateur précise la cible → le processus s’exécute sur cette cible ;
  - s’il ne précise pas → le système choisit automatiquement un item adéquat (type + quantité) dans le container concerné, selon une politique par défaut.
- Il faut installer un système de solutions de repli par défaut, permettant :
  - rapidité et faible friction,
  - ou grande précision si l’utilisateur le souhaite.

### 4.4 Modèle de processus (lignes Avant/Après)

- Interface divisée en deux colonnes (Avant / Après).
- À l’intérieur, des lignes représentent des « processus » :
  - chaque ligne est composée par exemple de :
    - la cible (container ou item),
    - l’action (créer / supprimer / modifier), éventuellement filtrée par type (nom, catégorie, état, échéance…).
- Ergonomie :
  - un mode ou bouton permet de choisir :
    - un container cible unique pour toutes les étapes,
    - un container pour l’Avant et un autre pour l’Après,
    - ou un container/item par ligne (granularité maximale).
  - À chaque fois, le composant de sélection universel est utilisé.

## 5. Pack Logique

### 5.1 Rôle général

- Permet de prendre la main sur le logiciel pour créer des logiques sur mesure et définir des types/catégories sur mesure.
- Capacités envisagées :
  - étendre les catégories d’état par défaut,
  - étendre les catégories d’échéances,
  - étendre les types de relations via la configuration globale,
  - écrire des règles logiques permettant de créer de nouvelles interactions à l’échelle du board.

### 5.2 Chevauchement avec Pack Interaction (question ouverte)

- Interaction intervient déjà pour produire des changements et appliquer des « règles » (Avant/Après) à l’échelle d’un board.
- Questions ouvertes :
  - le pack Logique doit-il permettre de créer des règles « à partir de rien » (bas niveau) ?
  - ou doit-il plutôt se concentrer sur l’ajout de catégories/types utilisables par le pack Interaction ?

### 5.3 Modèles envisagés

- Modèle 1 : Interaction seul (interface agréable, mais puissance limitée) :
  - avantage : simple à comprendre,
  - inconvénient : l’utilisateur ne peut pas tout faire.
- Modèle 2 : Logique + Interaction :
  - Logique :
    - définit des types d’échéances par défaut et leurs règles,
    - permet de choisir les événements déclencheurs (pas seulement « item terminé ») ;
  - Interaction :
    - expose ces capacités via l’UI Avant/Après,
    - fournit des événements et scénarios par défaut.

## 6. Pack Teams

### 6.1 Collaboration sur un même board

- Permettre à plusieurs utilisateurs de collaborer sur un même board.
- Introduction d’un système de droits complet pour :
  - accorder des droits de modification,
  - restreindre la visibilité de certains items,
  - accorder des droits conditionnels (par exemple voir un item uniquement si on y est assigné).

### 6.2 Hiérarchie et granularité des droits

- Nécessité d’une hiérarchie complète des droits :
  - droits d’assignation,
  - droits d’administration,
  - règles de priorité entre droits.
- Exemple d’objectif :
  - permettre à un administrateur de :
    - définir des droits pour ne pas avoir à surveiller le board,
    - encadrer les utilisateurs pour qu’ils puissent prendre des initiatives sans casser la structure.

## 7. Pack Community

### 7.1 Hub public et exposition partielle

- Ouvrir certains aspects des boards au public (avec consentement des utilisateurs).
- Comportement envisagé :
  - certains containers ou items peuvent être rendus publics,
  - un hub global :
    - devient la nouvelle page d’accueil (au lieu de « mes boards »),
    - affiche les boards ou parties rendues publiques,
    - met en avant les besoins exprimés via les packs d’interaction (actions en attente de certaines conditions).

### 7.2 Lien avec Interaction / besoins en ressources

- Les besoins déclarés via Interaction (conditions pour exécuter certaines actions) peuvent être :
  - exposés publiquement,
  - utilisés pour inviter d’autres utilisateurs à contribuer.

### 7.3 Tri et pertinence

- Prévoir un tri géographique ou contextuel pour augmenter la pertinence des recommandations :
  - proximité géographique,
  - thématiques,
  - domaines, etc.

## 8. Problèmes transverses à trancher

- Comportement des tags selon container/leaf :
  - faut-il des effets différents (visuels ou logiques) quand un tag est appliqué à un container plutôt qu’à un leaf ?
- Ligne entre tags et side panels :
  - certains panneaux (Relations, Progression, etc.) doivent-ils être visibles dès l’activation du pack, même sans tags ?
  - comment gérer le cas où un item n’a pas de tag spécifique mais possède des relations entrantes ?
- Où vivent les relations :
  - snapshot du board, graphe global, datasets packs, ou mix ?
  - implications sur cohérence, invariants (acyclicité), droits, cross-board.
- Lien entre hiérarchie visuelle (containers/children) et hiérarchie métier (`rel/hierarchy`) :
  - offrir à la fois des relations « libres » entre n’importe quels items, et un bouton « rendre cette liste fonctionnelle » ;
  - garder cette double capacité cohérente sans explosion de complexité.
- Interaction vs Logique :
  - clarifier le rôle exact de chaque pack pour éviter le double emploi ;
  - définir comment les règles (Logique) et les scénarios Avant/Après (Interaction) s’imbriquent.

## 9. Charte globale de cohérence (axes & responsabilités)

### 9.1 Axes de vérité

- **Axe Structure & Relations structurelles**
  - Vérités : arbre `BoardState` (parentId, children, sys.shape) + graphe de relations « fortes » (`rel/hierarchy`, `rel/dependency`, etc.).
  - Invariants :
    - leaf sans enfants,
    - acyclicité pour certaines relations (au minimum `rel/hierarchy` et `rel/dependency`),
    - références toujours valides (pas de relation pointant vers un node supprimé).
- **Axe État & Progression**
  - Vérités : tags d’état (`state/*`), progression numérique (0 → 10 000), échéances.
  - Invariants à renforcer :
    - un item en état « terminé » ne doit pas rester avec une progression incohérente (détails à trancher),
    - une seule échéance par catégorie pour un item.
- **Axe Droits & Visibilité (Teams)**
  - Vérités : qui voit quoi, qui peut changer quoi (ACL, rôles, règles de visibilité).
  - Invariants :
    - un utilisateur ne peut jamais obtenir plus de droits via un contournement (ex. Community),
    - les décisions de droits sont toujours appliquées avant les mutations (un acteur non autorisé ne peut pas muter).
- **Axe Automatisation & Logique (Interaction / Logique)**
  - Vérités : règles déclaratives (triggers/conditions/actions), scénarios Avant/Après, automations utilisateur.
  - Invariants :
    - aucune règle ne peut contourner les invariants des autres axes,
    - budget de règles limité (loop detection) pour éviter les boucles.
- **Axe Publication & Communauté (Community)**
  - Vérités : ce qui est publié dans le hub, les vues publiques, les « besoins » exposés.
  - Invariants :
    - la publication ne doit jamais exposer plus d’information que ce que les droits autorisent,
    - suppression/modification d’un board ou d’un item doit laisser les vues Community cohérentes (pas de liens cassés silencieux).

### 9.2 Propriétaires par axe

- **Structure & Relations structurelles**
  - Propriétaires :
    - Noyau V4 (BoardState, invariants de base),
    - Pack Relations (définition des types de relations structurantes, contraintes d’acyclicité, gestion du graphe).
  - Autres packs :
    - peuvent lire structure et relations,
    - ne doivent pas modifier directement parent/children ni créer/supprimer de relations structurantes.
- **État & Progression**
  - Propriétaire :
    - Pack Gestion (tags d’état supplémentaires, progression, échéances, règles associées).
  - Autres packs :
    - peuvent lire état/progression/échéances,
    - ne doivent pas imposer leurs propres invariants sur ces valeurs (ils peuvent au mieux proposer des changements via des commandes qui passent par les règles du pack Gestion).
- **Droits & Visibilité**
  - Propriétaire :
    - Pack Teams (ACL, rôles, hiérarchie des droits).
  - Autres packs :
    - peuvent demander une mutation, mais toute mutation passe par la couche droits,
    - ne doivent jamais modifier eux-mêmes les droits ou contourner les checks.
- **Automatisation & Logique**
  - Propriétaires :
    - Pack Logique (définition des types de règles, dictionnaire, actions/conditions),
    - Pack Interaction (construction d’actions Avant/Après consommant ce moteur).
  - Autres packs :
    - exposent des « capacités » (types de tags, relations, propriétés) que Logique/Interaction orchestrent,
    - ne doivent pas re-définir leur propre moteur de règles.
- **Publication & Communauté**
  - Propriétaire :
    - Pack Community (hub, vues publiques, règles de publication).
  - Autres packs :
    - fournissent des données annotées (tags, relations, besoins) que Community peut projeter,
    - ne doivent pas modifier directement les projections Community.

### 9.3 Patterns explicitement interdits

Pour éviter les boucles et les contradictions, certains schémas sont interdits dès le départ :

- **Teams ne modifie pas la structure ni les relations**
  - Les règles de droits peuvent bloquer ou autoriser des mutations,
  - mais elles ne créent ni ne suppriment des relations (`rel/hierarchy`, `rel/dependency`, etc.) et ne changent pas la structure de l’arbre.
- **Gestion ne modifie pas les relations structurelles**
  - Les règles du pack Gestion peuvent changer état, progression, échéances,
  - mais elles ne créent/suppriment jamais de relations structurantes et ne changent pas l’arbre parent/children.
- **Community ne modifie pas les droits internes**
  - Community peut publier des vues (hub, besoins publics) et refléter l’état/droits existants,
  - mais ne change jamais les droits internes Teams (pas de « promotion » d’utilisateurs via Community).
- **Automatisation ne change pas la structure en fonction de la progression**
  - Les règles Interaction/Logique peuvent changer état/progression en fonction de relations/structure,
  - mais l’inverse (modifier structure/relations en fonction de progression/état) est interdit pour éviter les boucles structure ↔ état.
- **Pas de moteur de règles parallèle**
  - Aucun pack ne doit introduire son propre moteur de règles autonome contournant celui du noyau (RulesEngine) :
    - toutes les automations doivent passer par le même RulesEngine,
    - ce moteur applique les priorités (Système > Packs > Utilisateur) et les garde-fous (budget, invariants).

Ce cadre sert d’« autoroute » : chaque pack peut être puissant sur son axe, mais ne peut pas casser la cohérence globale ni piloter les domaines qui ne sont pas les siens. Toute nouvelle feature ou règle devra être validée contre cette charte avant d’être acceptée.
